import { Course } from "src/ecommerce/courses/entites/courses.entity";
import { User } from "src/shared/users/entities/user.entity";
import { Column, DeleteDateColumn, Entity, ManyToOne, OneToMany, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Course_payment {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  asaasPaymentId: string;

  @ManyToOne(() => User)
  user: User;

  @ManyToOne(() => Course, { onDelete: 'CASCADE' })
  course: Course;

  @Column({ default: 'PENDING' })
  status: string; // PENDING, CONFIRMED, FAILED, etc.

  @Column()
  amount: number;

  @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
  created_at: Date;
}