import { User } from "src/shared/users/entities/user.entity";
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from "typeorm";
import { Course } from "./courses.entity";
import { Class } from "src/ecommerce/videos/entities/class.entity";

@Entity()
export class CourseLessonProgress{
    @PrimaryGeneratedColumn()
    id: number;

    @ManyToOne(() => User)
    user: User;

    @ManyToOne(() => Course)
    course: Course;

    @ManyToOne(() => Class, { onDelete: 'CASCADE' })
    class: Class;

    @Column()
    completed: boolean

    
    

}