import { Controller, Get, Post, Body, Patch, Param, Delete } from '@nestjs/common';
import { CupomService } from './cupom.service';
import { CreateCupomDto } from './dto/create-cupom.dto';
import { UpdateCupomDto } from './dto/update-cupom.dto';

@Controller('cupom')
export class CupomController {
  constructor(private readonly cupomService: CupomService) {}

  @Post()
  create(@Body() createCupomDto: CreateCupomDto) {
    return this.cupomService.create(createCupomDto);
  }
  @Post('/desconto/:orderId')
  descont(@Body() createCupomDto: CreateCupomDto, @Param('orderId') orderId: number){
    return this.cupomService.descont(orderId, createCupomDto.codigo);
  }
  @Post('/removeDesconto/:orderId')
  removeDescont(@Param('orderId') orderId: number){
    return this.cupomService.removeDescont(orderId);
  }



  @Get()
  findAll() {
    return this.cupomService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.cupomService.findOne(+id);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateCupomDto: UpdateCupomDto) {
    return this.cupomService.update(+id, updateCupomDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.cupomService.remove(+id);
  }
}
