import { Module } from '@nestjs/common';
import { DashboardService } from './dashboard.service';
import { DashboardController } from './dashboard.controller';
import { TypeOrmModule } from '@nestjs/typeorm/dist';
import { Order } from '../orders/entities/order.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';
import { Course_payment } from '../course_payment/entities/course_payment.entity';

@Module({
  imports: [TypeOrmModule.forFeature([Order, User, Course_payment]),
            JwtModule.register({ 
          secret: process.env.JWT_SECRET || 'secret', 
        }),],
  controllers: [DashboardController],
  providers: [DashboardService],
})
export class DashboardModule {}
