import { User } from 'src/shared/users/entities/user.entity';
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';

@Entity('frete_infos')
export class FreteInfo {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'varchar', length: 100, nullable: false })
  responsible_person: string;

  @Column({ type: 'varchar', length: 20, nullable: false })
  cellphone: string;

  @Column({ type: 'varchar', length: 10, nullable: false })
  cep: string;

  @Column({ type: 'varchar', length: 255, nullable: false })
  street: string;

  @Column({ type: 'varchar', length: 20, nullable: false })
  number: string;

  @Column({ type: 'varchar', length: 100, nullable: false })
  neighborhood: string;

  @Column({ type: 'varchar', length: 100, nullable: false })
  city: string;

  @Column({ type: 'varchar', length: 50, nullable: false })
  state: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  hour: string;

  @ManyToOne(() => User, (user) => user.freteInfos, {
    onDelete: 'CASCADE',
  })
  user: User;
}
