import { Order } from "src/ecommerce/orders/entities/order.entity";
import { Product } from "src/ecommerce/products/entities/product.entity";
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class OrderProduct {
    @PrimaryGeneratedColumn()
    id: number;

    @ManyToOne(() => Order, (order) => order.order_product, {onDelete: 'CASCADE', eager: true})
    order: Order;

    @ManyToOne(() => Product, (product) => product.order_product, {onDelete: 'CASCADE', eager: true})
    product: Product;

    @Column({ type: 'float'})
    quantity: number;

    @Column({ type: 'float'})
    unit_price: number;

}
