import { Order } from "src/ecommerce/orders/entities/order.entity";
import { Column, Entity, ManyToOne, PrimaryColumn, PrimaryGeneratedColumn } from "typeorm";
import { Status } from "src/shared/enums/enum";

@Entity()
export class OrderTransactions {
    @PrimaryGeneratedColumn()
    id: number

    @ManyToOne(() => Order, (order) => order.order_transaction)
    order: Order;

    @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
    updated_at: Date;

    @Column({ type: 'enum', enum: Status})
    status: Status;
}
