import { forwardRef, Module } from '@nestjs/common';
import { OrdersService } from './orders.service';
import { OrdersController } from './orders.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Order } from './entities/order.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';
import { OrderProduct } from 'src/ecommerce/orders/entities/order_product.entity';
import { AsaasModule } from 'src/ecommerce/asaas/asaas.module';
import { UsersModule } from 'src/shared/users/users.module';
import { OrderTransactions } from './entities/order_transaction.entity';
import { Product } from '../products/entities/product.entity';
import { Creditcard } from '../creditcard/entities/creditcard.entity';

@Module({
  imports: [forwardRef(() => AsaasModule), UsersModule,
    TypeOrmModule.forFeature([Order, User, OrderProduct, OrderTransactions, Product, Creditcard]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret'
    })
  ],
  controllers: [OrdersController],
  providers: [OrdersService],
  exports: [OrdersService]
})
export class OrdersModule {}
