import { BadRequestException, ConflictException, Injectable, NotFoundException } from '@nestjs/common';
import { CreateProductDto } from './dto/create-product.dto';
import { UpdateProductDto } from './dto/update-product.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Product } from './entities/product.entity';
import { Repository } from 'typeorm';
import { PutObjectCommand, S3Client } from '@aws-sdk/client-s3';

@Injectable()
export class ProductsService {
  constructor(
    @InjectRepository(Product)
    private productRepository: Repository<Product>
  ) {}

    private s3 = new S3Client({
    region: process.env.AWS_S3_REGION!,
    credentials: {
      accessKeyId: process.env.AWS_ACCESS_KEY_ID!,
      secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY!,
    },
  });

  async create(createProductDto: CreateProductDto) {
    const product = await this.productRepository.findOne({
      where: { 
        cod_product: createProductDto.cod_product
      }
    });

    if (product) {
      throw new ConflictException("Ops. Já existe um produto com esse código");
    }



    return await this.productRepository.save(
      this.productRepository.create(createProductDto)
    );
  }

  findAll() {
    return this.productRepository.find();
  }

  findAllForManagement() {
    return this.productRepository.find();
  }

  async findOneForManagement() {
    return this.productRepository.find();
  }
  
  async findOne(productId: number) {
    const product = await this.productRepository.findOneBy({id: productId});
    
    if (!product) { throw new NotFoundException("Ops. Produto não encontrado"); }

    return product;
  }

  async update(productId: number, updateProductDto: UpdateProductDto) {
    const product = await this.findProductById(productId);

    const productUpdated = this.productRepository.merge(product, updateProductDto);

    try { 
      await this.productRepository.save(productUpdated);
    } catch (error) {
      throw new BadRequestException("Erro ao tentar atualizar um ou mais dados do produto. Error: ", error);
    }

    return { message: "Produto atualziado com sucesso" };
  }

  async remove(productId: number) {
    const product = await this.findProductById(productId);

    try { 
      await this.productRepository.remove(product);
    } catch (error) {
      console.log(error);
      throw new BadRequestException("Erro ao tentar remover o produto. Erro", error);
    }

    return { message: "Produto removido com sucesso"}; 
  }

  /* ### Funções Auxiliares ### */

  async findProductById(productId: number) {
    const product = await this.productRepository.findOneBy({id: productId});

    if (!product) {
      throw new NotFoundException("Produto não encontrado");
    }

    return product;
  }

    async uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string> {
      const bucketName = process.env.AWS_S3_BUCKET!;
  
        //  const buffer = await sharp(file?.buffer)
                
        //         .toBuffer();
      
  
      const uploadParams = new PutObjectCommand({
        Bucket: bucketName,
        Key: fileName,
        Body: file.buffer,
        ContentType: file.mimetype,
      });
  
      console.log(uploadParams);
  
      try {
        await this.s3.send(uploadParams);
        return `https://${bucketName}.s3.${process.env.AWS_S3_REGION}.amazonaws.com/${fileName}`;
      } catch (err) {
        throw new BadRequestException('Erro ao enviar arquivo para o S3: ' + err);
      }
    }
}