import { Controller, Get, Post, Body, Patch, Param, Delete, Query, UseGuards } from '@nestjs/common';
import { ReportsService } from '../../application/services/reports.service';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { Roles } from 'src/shared/enums/enum';
import { CurrentUser } from 'src/shared/users/current.user.decorator';

@Controller('relatorios')
export class ReportsController {
  constructor(private readonly reportsService: ReportsService) {}

  @Get('/pedidos-por-hora')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  getOrdersPerHour(@Query('intervalo') date: string) {
    return this.reportsService.getOrdersPerHour(date);
  }
  
  @Get('clientes')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  findAllClientsByStoreId() {
    return this.reportsService.findAllClients();
  }

  @Get('cards')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  getCardsInfo() {
    return this.reportsService.getCardsInfo()
  }

  @Get('total-da-loja')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  countTotalAmount() {
    return this.reportsService.countTotalAmount();
  }

  @Get(':orderId/pedido')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  getDetailsByOrderId(@Param('orderId') orderId: string, @CurrentUser('id') currentUserId: number) { 
    return this.reportsService.getDetailsByOrderId(+orderId);
  }

  @Get('/pedidos-finalizados')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  getFinishedOrders() {
    return this.reportsService.getFinishedOrders()
  }

  @Get('/top-produtos')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE, Roles.ADMFINANCIAL)
  getTopProductsPerDay() {
    return this.reportsService.getTopProductsPerDay();
  }
}
