import { IsNotEmpty, IsNumber, IsPositive } from "class-validator";

export class AddItemFromCartDto {
    @IsNotEmpty({ message: "O id do produto é obrigatório"})
    productId: number;

    @IsPositive({ message: "A quantidade deve ser um número positivo"})
    @IsNumber({}, { message: "A quantidade deve ser um número válido"})
    quantity: number;
}
