import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards, UseInterceptors, UploadedFile, BadRequestException } from '@nestjs/common';
import { SignaturesService } from './signatures.service';
import { CreateSignatureDto } from './dto/create-signature.dto';
import { UpdateSignatureDto } from './dto/update-signature.dto';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { Roles } from 'src/shared/enums/enum';
import { FileInterceptor } from '@nestjs/platform-express';
import { diskStorage } from 'multer';
import * as multerS3 from 'multer-s3';
import { S3Client, PutObjectCommand } from '@aws-sdk/client-s3';
import { extname } from 'path';


@Controller('signatures')
export class SignaturesController {
  constructor(private readonly signaturesService: SignaturesService) {}

  @Post('/registro')
  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  @UseInterceptors(FileInterceptor('file'))
  async create(
    @Body() createSignatureDto: CreateSignatureDto,
    @UploadedFile() file?: Express.Multer.File,
  ) {
    if (file) {
    
      try {
         const imageUrl = await this.signaturesService.uploadImageToS3(file, file.originalname);
          createSignatureDto.imageUrl = imageUrl;
      } catch (error) {
        throw new BadRequestException('Falha ao enviar imagem para o S3: ' + error);
      }
    }
    return this.signaturesService.create(createSignatureDto);
  }

  @Get('/')
  findAll() {
    return this.signaturesService.findAll();
  }

  @Get('/restrito')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  findAllForManagement() {
    return this.signaturesService.findAllForManagement();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.signaturesService.findOne(+id);
  }

  @Get(':id/restrito')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  findOneForManagement() {
    return this.signaturesService.findOneForManagement();
  }

  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
 @Patch(':id')
  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  @UseInterceptors(FileInterceptor('file'))
  async update(
    @Param('id') id: string,
    @Body() updateSignatureDto: UpdateSignatureDto,
    @UploadedFile() file?: Express.Multer.File,
  ) {
    console.log("FILE CONTROLLER ", file);
    
    if (file) {
      const ext = extname(file.originalname);
      const fileName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${ext}`;

      try {
        const imageUrl = await this.signaturesService.uploadImageToS3(file, fileName);
        updateSignatureDto.imageUrl = imageUrl;
      } catch (error) {
        throw new BadRequestException('Falha ao enviar imagem para o S3: ' + error);
      }
    }

    return this.signaturesService.update(+id, updateSignatureDto);
  }

  @Delete(':id')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  remove(@Param('id') id: string) {
    return this.signaturesService.remove(+id);
  }
}
