import { Module } from '@nestjs/common';
import { SignaturesService } from './signatures.service';
import { SignaturesController } from './signatures.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Signature } from './entities/signature.entity';
import { JwtModule } from '@nestjs/jwt';


@Module({
  imports: [TypeOrmModule.forFeature([Signature]),
    JwtModule.register({ 
          secret: process.env.JWT_SECRET || 'secret', 
        }),
    ],
  controllers: [SignaturesController],
  providers: [SignaturesService],
  exports: [SignaturesService]
})
export class SignaturesModule {}
