import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards, UseInterceptors, UploadedFile, BadRequestException, UploadedFiles } from '@nestjs/common';
import { ClassesService } from './classes.service';
import { CreateClassDto } from './dto/create-video.dto';
import { UpdateClassDto } from './dto/upload-video.dto';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { Roles } from 'src/shared/enums/enum';
import { FileInterceptor, FilesInterceptor } from '@nestjs/platform-express';
import { diskStorage } from 'multer';
import * as multerS3 from 'multer-s3';
import { S3Client, PutObjectCommand } from '@aws-sdk/client-s3';
import { extname } from 'path';


@Controller('video')
export class ClassesController {
  constructor(private readonly classService: ClassesService) {}

  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  // @Post('/registro')
  // @UseInterceptors(FilesInterceptor('files')) // agora aceita múltiplos arquivos
  // async createMany(
  //   @Body() createClassesDto: CreateClassDto[],
  //   @UploadedFiles() files?: Express.Multer.File[],
  // ) {
  //   if (files && files.length > 0) {
  //     try {
  //       // faz upload para cada arquivo e adiciona a URL correspondente
  //       for (let i = 0; i < createClassesDto.length; i++) {
  //         const file = files[i];
  //         if (file) {
  //           const videoUrl = await this.classService.uploadImageToS3(
  //             file,
  //             file.originalname,
  //           );
  //           createClassesDto[i].url = videoUrl;
  //         }
  //       }
  //     } catch (error) {
  //       throw new BadRequestException('Falha ao enviar arquivos: ' + error);
  //     }
  //   }

  //   // salva todas as classes de uma vez
  //   return this.classService.create(createClassesDto);
  // }




 // kokokookokokoko

//   @Post('/registro')
// @UseInterceptors(FilesInterceptor('files'))
// async createMany(
//   @Body() body: any,
//   @UploadedFiles() files?: Express.Multer.File[],
// ) {
//   let lessons: CreateClassDto[] = [];


//   console.log("lessons ", lessons);
  
  
//   // Se vier como string (caso de multipart/form-data)
//   if (typeof body === 'string') {
//     lessons = JSON.parse(body);
//   } 
//   // Se vier com campo específico
//   else if (typeof body.createClassDto === 'string') {
//     lessons = JSON.parse(body.createClassDto);
//   } 
//   else {
//     lessons = body;
//   }

//   // 👉 Agora o array está garantido
//   if (!Array.isArray(lessons)) {
//     throw new BadRequestException('O corpo da requisição deve ser um array de classes');
//   }

//   // (se tiver upload, associar arquivos, etc)
//   if (files && files.length > 0) {
//     for (let i = 0; i < lessons.length; i++) {
//       const file = files[i];
//       if (file) {
//         const videoUrl = await this.classService.uploadImageToS3(file, file.originalname);
//         lessons[i].url = videoUrl;
//       }
//     }
//   }

//   return this.classService.create(lessons);
// }

@Post('/registro')
@UseInterceptors(FilesInterceptor('files')) // 'files' deve bater com a chave do arquivo no Postman
async createMany(
  @Body() body: any,
  @UploadedFiles() files?: Express.Multer.File[],
) {
  let createClassDtoArray: CreateClassDto[];

  // 1. CORREÇÃO: Verifique a chave 'data' (baseado no seu print do Postman)
  if (body.data && typeof body.data === 'string') {
    try {
      createClassDtoArray = JSON.parse(body.data);
    } catch (e) {
      throw new BadRequestException('O JSON enviado no campo "data" é inválido.');
    }
  } else {
    // Caso venha como JSON puro (sem arquivos) ou o body já esteja parseado
    createClassDtoArray = body;
  }

  // 2. SEGURANÇA: Descomente essa validação!
  // Se o JSON.parse retornar um objeto simples em vez de array, o loop abaixo quebra.
  if (!Array.isArray(createClassDtoArray)) {
     // Se for um objeto único, transforme em array para o código não quebrar
     createClassDtoArray = [createClassDtoArray] as any;
  }

  console.log("Array processado: ", createClassDtoArray);

  // 3. ASSOCIAÇÃO DE ARQUIVOS
  // Cuidado: Isso assume que a ordem dos arquivos é a mesma ordem do array de classes
  if (files && files.length > 0) {
    for (let i = 0; i < createClassDtoArray.length; i++) {
      // Verifica se existe arquivo para esta posição do array
      if (files[i]) {
        const file = files[i];
        const videoUrl = await this.classService.uploadImageToS3(file, file.originalname);
        createClassDtoArray[i].url = videoUrl;
      }
    }
  }  

  // 4. SERVICE
  // Certifique-se que seu service aceita um ARRAY. 
  // Se o método .create() esperar um único objeto, você terá que usar .save() do repositório
  // ou fazer um loop aqui também.
  return this.classService.create(createClassDtoArray); 
}


  @Get('/')
  findAll() {
    return this.classService.findAll();
  }

  @Get('/restrito')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  findAllForManagement() {
    return this.classService.findAllForManagement();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.classService.findOne(+id);
  }

  @Get(':id/restrito')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  findOneForManagement() {
    return this.classService.findOneForManagement();
  }

  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
 @Patch('editar')
  // @UseGuards(AuthGuard, RoleGuard)
  // @RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  @UseInterceptors(FileInterceptor('file'))
  async update(
    @Body() updateClassDto: UpdateClassDto,
    @UploadedFile() file?: Express.Multer.File,
  ) {
    console.log("FILE CONTROLLER ", file);
    console.log("DTO CONTROLLER ", updateClassDto);
    
    if (file) {
      const ext = extname(file.originalname);
      const fileName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${ext}`;

      try {
        const videoUrl = await this.classService.uploadImageToS3(file, fileName);
        updateClassDto.url = videoUrl;
      } catch (error) {
        throw new BadRequestException('Falha ao enviar imagem para o S3: ' + error);
      }
    }

    return this.classService.update( updateClassDto);
  }

  @Delete(':id')
  //@UseGuards(AuthGuard, RoleGuard)
  //@RequiredRoles(Roles.ADMIN, Roles.ADMECOMMERCE)
  remove(@Param('id') id: string) {
    return this.classService.remove(+id);
  }
}
