// Certifique-se que o caminho do import está correto
import { Course } from "src/ecommerce/courses/entites/courses.entity";
import { Column, Entity, PrimaryGeneratedColumn, ManyToOne, ManyToMany } from "typeorm";

@Entity()
export class Class {

  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  title: string;

  @Column()
  description: string;

  @Column()
  url: string;

  // RELACIONAMENTO ADICIONADO AQUI
  // O primeiro argumento retorna o tipo da entidade alvo (Course)
  // O segundo argumento indica qual propriedade na entidade Course aponta para esta lista de aulas
  @ManyToMany(() => Course, (course) => course.classes, {
  })
  courses: Course[];
}