import { JwtModule } from '@nestjs/jwt';
import { forwardRef, Module } from '@nestjs/common';
import { AuthService } from './auth.service';
import { AuthController } from './auth.controller';
import { UsersModule } from 'src/shared/users/users.module';
import { AuthGuard } from './auth.guard';
import { PermissionsGuard } from './permissions.guards';
import { AppGateway } from './handshake.auth';
import { EquipamentsService } from 'src/visoflex360/equipaments/equipaments.service';
import { EquipamentsModule } from 'src/visoflex360/equipaments/equipaments.module';

@Module({
  imports: [
    forwardRef(() => UsersModule),
    EquipamentsModule,
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret',
//      // signOptions: { expiresIn: '24h' },
    }),
  ],
  controllers: [AuthController],
  providers: [AuthService,AuthGuard, AppGateway],
  exports: [AuthGuard, AuthService],
})
export class AuthModule {}
