import { Roles } from 'src/shared/enums/enum';
import { JwtService } from "@nestjs/jwt";
import { WebSocketGateway, WebSocketServer, OnGatewayConnection} from "@nestjs/websockets";
import { Server, Socket } from "socket.io";
import { EquipamentsService } from 'src/visoflex360/equipaments/equipaments.service';
import { Equipament } from 'src/visoflex360/equipaments/entities/equipament.entity';

@WebSocketGateway()
export class AppGateway implements OnGatewayConnection {
    @WebSocketServer()
    server: Server;

    constructor(
        private jwtService: JwtService,
        private equipamentService: EquipamentsService
    ) {}

    handleConnection(socket: Socket) {

        const token = socket.handshake.auth?.token;

        if (!token) {
            socket.disconnect(true);
            return;
        }
        try {
             
            const payload = this.jwtService.verify(token);

            if (payload.roles === Roles.ADMVISO360, Roles.ADMIN) {
                socket.join('admin');
            } else {
                const userId = payload.id;
                
                socket.join(`user-${userId}`);
                this.equipamentService.updateUserCards(userId);
            }            
        } catch (err) {
            socket.disconnect();
        }
    }
}