import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { Roles } from 'src/shared/enums/enum';
import { Request } from 'express';
import { ROLES_KEY } from '../required-roles.decorator';

declare module 'express' {
  interface Request {
    user?: any;
  }
}

@Injectable()
export class RoleGuard implements CanActivate {

  constructor(private reflector : Reflector) {}
  canActivate(
    context: ExecutionContext): boolean {

      const requiredRoles = this.reflector.getAllAndOverride<Roles[]>(ROLES_KEY, [
        context.getHandler(),
        context.getClass(),
      ]);

      if(!requiredRoles){
        return true;
      }
      
      const request: Request = context.switchToHttp().getRequest();
      const authUser = request.user;
      return requiredRoles.some((role) => authUser.roles?.includes(role));
    }
  }
