import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { CategoryService } from './category.service';
import { CreateCategoryDto } from './dto/create-category.dto';
import { UpdateCategoryDto } from './dto/update-category.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { Roles } from 'src/shared/enums/enum';
import { ApiTags } from '@nestjs/swagger';

@ApiTags('Categoria dos Equipamentos')
@Controller('categoria')
export class CategoryController {
  constructor(private readonly categoryService: CategoryService) {}

  @Post('/registro')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  create(@Body() createCategoryDto: CreateCategoryDto) {
    return this.categoryService.create(createCategoryDto);
  }

  @Get()
  @UseGuards(AuthGuard)
  findAll() {
    return this.categoryService.findAll();
  }

  @Get(':id')
  @UseGuards(AuthGuard)
  findOne(@Param('id') id: string) {
    return this.categoryService.findOne(+id);
  }

  @Patch(':id')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  update(@Param('id') id: string, @Body() updateCategoryDto: UpdateCategoryDto) {
    return this.categoryService.update(+id, updateCategoryDto);
  }

  @Delete(':id')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  remove(@Param('id') id: string) {
    return this.categoryService.remove(+id);
  }
}
