import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateCategoryDto } from './dto/create-category.dto';
import { UpdateCategoryDto } from './dto/update-category.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository, createQueryBuilder } from 'typeorm';
import { Category } from './entities/category.entity';

@Injectable()
export class CategoryService {
  constructor(
    @InjectRepository(Category)
    private categoryRepository: Repository<Category>
  ){}

  async create(createCategoryDto: CreateCategoryDto) { 
    const category = this.categoryRepository.create(createCategoryDto)
    return this.categoryRepository.save(category);
  }

  findAll() {
    return this.categoryRepository.find();
  }

  findOne(id: number) {
    return this.categoryRepository.findOneBy({id})
  }

  async update(id: number, updateCategoryDto: UpdateCategoryDto) {
    const category = await this.categoryRepository.findOneBy({id})
    if (!category) {
      throw new NotFoundException("Categoria não encontrada")
    };
    this.categoryRepository.merge(category, updateCategoryDto);
    return category;
  }

  async remove(id: number) {
    const category = await this.categoryRepository.findOneBy({id});
    if (!category) {
      throw new NotFoundException("Categoria não encontrada");
    }
    return this.categoryRepository.remove(category);
  }
}
