import { ApiProperty } from '@nestjs/swagger';
import { Transform } from 'class-transformer';
import {
  IsEmail,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsStrongPassword,
  Length,
  MinLength,
} from 'class-validator';
import { Roles } from 'src/shared/enums/enum';

export class CreateUserDto {
  @IsNotEmpty({ message: 'O campo CNPJ da Empresa é obrigatório' })
  @Length(9, 14, { message: 'O campo de CNPJ deve conter 14 digitos' })
  // @IsNumber({}, { message: 'O documento deve conter apenas números' })
  document: string;

  @Transform(({ value }) => value.toLowerCase())
  @IsString({ message: 'O nome da empresa deve ser uma string.' })
  @MinLength(3, {
    message: 'O nome da empresa deve ter no mínimo 3 caracteres.',
  })
  @IsNotEmpty({ message: 'O campo nome da empresa é obrigatório' })
  company_name: string;

  @Transform(({ value }) => value.toLowerCase())
  @IsString({ message: 'O nome deve ser uma string.' })
  @IsNotEmpty({ message: 'O nome não pode estar vazio.' })
  @MinLength(3, { message: 'O nome deve ter no mínimo 3 caracteres.' })
  user_name: string;

  @IsNotEmpty({ message: 'O campo telefone não pode ser vázio' })
  @Length(11, 11, { message: 'O campo telefone deve 11 digitos' })
  // @IsNumber( {}, { message: 'O campo telefone deve conter apenas números' })
  cellphone: string;

  @Transform(({ value }) => value.toLowerCase())
  @IsEmail({}, { message: 'Por favor, forneça um endereço de e-mail válido.' })
  @IsNotEmpty({ message: 'O e-mail não pode estar vazio.' })
  email: string;

  @IsNotEmpty({ message: 'O campo senha é obrigatório' })
  @IsStrongPassword(
    { minLength: 6, minLowercase: 0, minUppercase: 0, minSymbols: 0 },
    { message: 'A senha deve conter pelo menos 6 caracteres' },
  )
  password: string;

  @IsOptional()
  @IsEnum(Roles)
  roles: Roles;
}

export class CreateUserResponseDto {
  'access_token': string;
}
