import { IsEmail, IsNotEmpty, IsStrongPassword, Length, Matches } from "class-validator";

export class forgotPasswordDto {
    @IsEmail({}, { message:  "O e-mail precisa válido"})
    @IsNotEmpty({ message: "O campo e-mail não pode ser vázio"})
    email: string;
}

export class ResetPasswordDto{
    @IsEmail({}, { message:  "O e-mail precisa válido"})
    @IsNotEmpty({ message: "O campo e-mail não pode ser vázio"})
    email: string;

    @IsNotEmpty({ message: 'A senha não pode ser vazia.' })
    @IsStrongPassword(
        { minLength: 8, minLowercase: 1, minUppercase: 1, minNumbers: 1, minSymbols: 1 },
        { message: 'A senha deve ter no mínimo 8 caracteres, com pelo menos uma letra maiúscula, uma minúscula, um número e um caractere especial.' },
    )
    newPassword: string;

    @IsNotEmpty({ message: 'O código não pode estar vazio' })
    @Length(6, 6, { message: 'O código deve ter exatamente 6 caracteres' })
    @Matches(/^\d{6}$/, { message: 'O código deve conter apenas números' })
    code: string;
}