import { forwardRef, Module } from '@nestjs/common';
import { UsersService } from './users.service';
import { UsersController } from './users.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { User } from './entities/user.entity';
import { Equipament } from 'src/visoflex360/equipaments/entities/equipament.entity';
import { Door } from 'src/visoflex360/doors/entities/door.entity';
import { JwtModule } from '@nestjs/jwt';
import { EquipamentsService } from 'src/visoflex360/equipaments/equipaments.service';
import { EquipamentsModule } from 'src/visoflex360/equipaments/equipaments.module';
import { AuthService } from 'src/shared/auth/auth.service';
import { AuthModule } from 'src/shared/auth/auth.module';
import { PasswordResetToken } from './entities/password-reset-token.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([User, Equipament, Door, PasswordResetToken]),
    forwardRef(() => AuthModule),  
    JwtModule.register({ 
      secret: process.env.JWT_SECRET || 'secret', 
    //  signOptions: { expiresIn: '24h' }
    }),
  ],
  controllers: [UsersController],
  providers: [UsersService],
  exports: [UsersService],
})
export class UsersModule {}
