import { BadRequestException, Injectable, Post } from '@nestjs/common';
import { CreateAgendaDto } from './dto/create-agenda.dto';
import { UpdateAgendaDto } from './dto/update-agenda.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Agenda } from './entities/agenda.entity';
import { Repository } from 'typeorm';

@Injectable()
export class AgendaService {
  constructor(
    @InjectRepository(Agenda)
    private agendaRepository: Repository<Agenda>,
  ) {}

  async create(createAgendaDto: CreateAgendaDto) {
    const novoAgendamendo = await this.agendaRepository.create(createAgendaDto);
    return await this.agendaRepository.save(novoAgendamendo);
  }

  findAll() {
    return this.agendaRepository.find();
  }

  async findOne(id: number) {
    const exist = await this.agendaRepository.findOne({
      where: { id },
    });

    if (!exist) {
      throw new BadRequestException('agenda não existe');
    }

    return exist;
  }

  async update(id: number, updateAgendaDto: UpdateAgendaDto) {
    const exist = await this.agendaRepository.findOne({
      where: { id },
    });

    if (!exist) {
      throw new BadRequestException('agenda não existe');
    }

    return await this.agendaRepository.update({ id }, { ...updateAgendaDto });
  }

  async remove(id: number) {
    const exist = await this.agendaRepository.findOne({
      where: { id },
    });

    if (!exist) {
      throw new BadRequestException('agenda não existe');
    }

    return await this.agendaRepository.delete({ id });
  }
}
