import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards, Req } from '@nestjs/common';
import { ContactsService } from './contacts.service';
import { CreateContactDto } from './dto/create-contact.dto';
import { UpdateContactDto } from './dto/update-contact.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { PermissionsGuard } from 'src/shared/auth/permissions.guards';
import { ApiTags } from '@nestjs/swagger';

@ApiTags('Contatos dos avisos/alertas')
@Controller('contatos')
export class ContactsController {
  constructor(private readonly contactsService: ContactsService) {}

  @Post('/registro/:id')
  @UseGuards(AuthGuard, PermissionsGuard)
  create(@Param('id') id: number, @Body() createContactDto: any) {
    return this.contactsService.create(+id, createContactDto);
  }

  @Get('/')
  @UseGuards(AuthGuard)
  findAllByUser(@Req() req) {
    return this.contactsService.findAllByUser(req.user.id);
  }

  @Get('/:id')
  @UseGuards(AuthGuard)
  findByUser(@Param('id') id: string) {
    return this.contactsService.findAllByUser(+id);
  }
}
