import { Module } from '@nestjs/common';
import { ContactsService } from './contacts.service';
import { ContactsController } from './contacts.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { User } from 'src/shared/users/entities/user.entity';
import { Contact } from './entities/contact.entity';
import { JwtModule } from '@nestjs/jwt';
import { DoorsModule } from 'src/visoflex360/doors/doors.module';
import { IndustrialFansModule } from 'src/visoflex360/industrial_fans/industrial_fans.module';

@Module({
  imports: [TypeOrmModule.forFeature([Contact, User]),
    JwtModule.register({ 
          secret: process.env.JWT_SECRET || 'secret', 
        //  signOptions: { expiresIn: '24h' }
        }),
  ],
  controllers: [ContactsController],
  providers: [ContactsService],
})
export class ContactsModule {}
