import { Length } from 'class-validator';
import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateContactDto } from './dto/create-contact.dto';
import { UpdateContactDto } from './dto/update-contact.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Contact } from './entities/contact.entity';
import { Repository } from 'typeorm';

@Injectable()
export class ContactsService {
  constructor(
    @InjectRepository(Contact)
    private contactRepository: Repository<Contact>,
  ){}

async create(userId: number, createContactDto: CreateContactDto[]) {
  const results: (Contact | { cellphone: string; message: string })[] = [];
  await this.contactRepository.delete({ user: { id: userId } });

  for (const dto of createContactDto) {
    let contact = await this.contactRepository.findOne({
      where: { cellphone: dto.cellphone }
    });

    if (!contact) {
      contact = this.contactRepository.create({
        ...dto,
        user: { id: userId }
      });
      const saved = await this.contactRepository.save(contact);
      results.push(saved);
    } else {
      results.push({ cellphone: dto.cellphone, message: "Contato já existente!" });
    }
  }

  return results;
}

  findAllByUser(userId: number){
    const contact = this.contactRepository.find({
      where: { user: {id: userId} },
    });
    return contact;
  }

  findOneBy(id: number){
    return this.contactRepository.findOneBy({id});
  }

  async update(userId, id: number, updateContactDto: UpdateContactDto) {
    const contact = await this.contactRepository.findOne({
      where: {
        id: id,
        user: { id: userId}
      }
    })

    if (!contact) {
      throw new NotFoundException("Contato não encontrado");
    }

    this.contactRepository.merge(contact, updateContactDto)
    return this.contactRepository.save(contact);
  }
}
