import { PartialType } from '@nestjs/mapped-types';
import { CreateDoorDto } from './create-door.dto';
import { IsBoolean, IsNumber } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class UpdateDoorDto extends PartialType(CreateDoorDto) {
    @ApiProperty({ description: 'Número de ciclos da porta', type: Number, required: false})
    @IsNumber({}, { message: 'ID deve conter somente números válidos.' })
    cicles?: number;

    @ApiProperty({ description: 'Indica se a porta tem algum alerta', type: Boolean, required: false})
    @IsBoolean({ message: 'has_alert deve ser um valor booleano.' })
    has_alert?: boolean;

    @ApiProperty({ description: 'Indica se a porta está aberta', type: Boolean, required: false})
    @IsBoolean({ message: 'is_open deve ser um valor booleano.' })
    is_open?: boolean;
}
