import { CreateDoorDto } from "src/visoflex360/doors/dto/create-door.dto";
import { CreateEquipamentDto } from "./create-equipament.dto";
import { CreateIndustrialFanDto } from "src/visoflex360/industrial_fans/dto/create-industrial_fan.dto";
import { User } from "src/shared/users/entities/user.entity";
import { ApiProperty } from "@nestjs/swagger";

export class CreateEquipamentWithTypeDto {
    @ApiProperty({ description: 'Dados do equipamento', type: CreateEquipamentDto, required: true })
    equipament: CreateEquipamentDto;

    @ApiProperty({ description: 'Dados da porta', type: CreateDoorDto, required: false, example: { cicles: 0, is_open: false, has_alert: false} })
    door?: CreateDoorDto;

    @ApiProperty({ description: 'Dados do ventilador', type: CreateIndustrialFanDto, required: false, example: null })
    fan?: CreateIndustrialFanDto;

    user?: User;
}