import { MessageBody, SubscribeMessage, WebSocketGateway, WebSocketServer } from '@nestjs/websockets';
import { Server } from 'socket.io';
import { EquipamentsService } from './equipaments.service';
import { OnEvent } from '@nestjs/event-emitter'

@WebSocketGateway()
export class EquipamentsGateway {
  constructor( private readonly equipamentsService: EquipamentsService) {}

  @WebSocketServer()
  server: Server

  @SubscribeMessage('receiveId')
  async handleUpdateUserCardsID(@MessageBody() data: { userId }) {
    this.updateUserCards(data.userId)
  }

  @OnEvent('receiveId')
  async updateUserCards(userId: number) {
    this.server.to(`user-${userId}`).emit('updateUserCards', await this.equipamentsService.updateUserCards(userId));
    this.server.to('admin').emit('updateUserCards', await this.equipamentsService.updateUserCards(userId));   
  } 

  @OnEvent('statusEquipChangeAdm')
  statusEquipChangeAdm({userId, alertCount} : { userId: number, alertCount: number}) {
    this.server.to('admin').emit('statusEquipChangeAdm', { userId, alertCount});
  }
  
  @OnEvent('statusEquipChange')
  statusEquipChange({userId, equipId, isOpen, hasAlert, cicles, date}) {
    this.server.to(`user-${userId}`).emit('statusEquipChange');
    this.server.to('admin').emit('statusEquipChange', {userId, equipId, isOpen, hasAlert, cicles, date})
  }
}

