import { Module } from '@nestjs/common';
import { EquipamentsService } from './equipaments.service';
import { EquipamentsController } from './equipaments.controller';
import { Equipament } from './entities/equipament.entity';
import { Door } from 'src/visoflex360/doors/entities/door.entity';
import { IndustrialFan } from 'src/visoflex360/industrial_fans/entities/industrial_fan.entity';
import { TypeOrmModule } from '@nestjs/typeorm';
import { JwtModule } from '@nestjs/jwt';
import { DoorsModule } from 'src/visoflex360/doors/doors.module';
import { IndustrialFansModule } from 'src/visoflex360/industrial_fans/industrial_fans.module';
import { EquipamentsGateway } from './equipaments.gateway';
import { User } from 'src/shared/users/entities/user.entity';
import { Model } from 'src/visoflex360/models/entities/model.entity';
import { Watcher } from 'src/visoflex360/watchers/entities/watcher.entity';
import { Schedules } from 'src/visoflex360/equipaments/entities/schedules.entity';
import { Group } from '../group/entities/group.entity';

@Module({
  imports: [TypeOrmModule.forFeature([Equipament, Door, IndustrialFan, User, Model, Watcher, Schedules, Group]),
  JwtModule.register({ 
        secret: process.env.JWT_SECRET || 'secret', 
      }),
  DoorsModule,
  IndustrialFansModule,
    ],
  controllers: [EquipamentsController],
  providers: [EquipamentsService, EquipamentsGateway],
  exports: [EquipamentsService]
})
export class EquipamentsModule {}
