import { ApiProperty } from '@nestjs/swagger';
import { IsBoolean, IsDecimal, IsNotEmpty, IsNumber, IsOptional, IsString, Length, Matches } from "class-validator";
import { FileType } from '../entities/files.entity';
export class CreateFilesDto {
        @ApiProperty({ description: 'Título do arquivo', type: String, required: true})
        @IsNotEmpty({ message: 'O titulo do arquivo não pode ser nulo' })
        @IsString({ message: 'O título do arquivo de ser uma texto válido'})
        file_name: string;
    
        
        @ApiProperty({ description: 'Versão do arquivo', type: String, required: true})
        @Matches(/^\d+(\.\d+)?$/, { message: 'A versão do arquivo deve ser um número válido, como "1.0" ou "2.5".' })        @IsNotEmpty({ message: 'A versão é obrigatória '})
        version: string;

        @ApiProperty({ description: 'Descrição do arquivo', type: String, required: true })
        @IsOptional()
        @IsString({ message: 'A descrição de arquivo deve ser um texto válido'})
        description: string;

        @ApiProperty({ description: 'id da pasta pai', type: String, required: true })
        @IsNotEmpty({ message: 'o id da pasta pai deve ser informado' })
        folder: string;

        
}
