import { PartialType } from '@nestjs/mapped-types';
import { CreateFilesDto } from './create-files.dto';
import { IsNotEmpty, IsString } from 'class-validator';

export class UpdateFilesDto extends PartialType(CreateFilesDto) {
    @IsNotEmpty({message: "O nome do arquivo não pode estar vázio"})
    @IsString({message: "O nome do arquivo deve conter apenas texto"})
    file_name: string;

    @IsNotEmpty({message: "A descrição não pode estar vázia"})
    @IsString({message: "A descrição deve conter apenas texto"})
    description: string

    @IsNotEmpty({message: "O arquivo não pode estar vázio. Adicione um arquivo válido"})
    content: string;
}
