import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from "typeorm";
import { Folder } from "./path.entity";

export enum FileType {
  PDF = "pdf",
  JPEG = "jpeg",
  PNG = "png",
  JPG = "jpg"
}

@Entity()
export class Files {
    @PrimaryGeneratedColumn({ type: 'smallint',  })
    id: number;

    @Column({ type: 'varchar', length: 30, nullable: false })
    file_name: string;

    @Column({ type: 'varchar', length: 30, nullable: false})
    name: string;

    @Column({ type: 'varchar', length: 10, nullable: false })
    version: string;

    @Column({ type: 'varchar', length: 110, nullable: false })
    description: string;
    
    @Column({ type: 'varchar', nullable: true})
    path: string;

    @Column({ type: 'varchar', nullable: false })
    type: string;

    @Column({ type: 'tinyint', nullable: false})
    size: number;

    @ManyToOne(() => Folder, (folder) => folder.files, {onDelete: 'CASCADE', eager: true})
    folder: Folder;

    @Column({ type: 'timestamp', nullable: false, default: () => 'CURRENT_TIMESTAMP' })
    created_on: Date;
}