import { Entity, PrimaryGeneratedColumn, Column, CreateDateColumn, OneToMany, ManyToOne } from 'typeorm';
import { Files } from './files.entity';

@Entity('folders')
export class Folder {
  @PrimaryGeneratedColumn() 
  id: number;

  @Column()
  name: string;

  @Column()
  path: string; // Ex: "Manuais/Instalação/Manuais Técnicos"

  // Armazena o array ["admin", "user"] diretamente no banco
  @Column('simple-array') // Use 'json' se estiver no Postgres ou MySQL moderno
  allowedRoles: string[];

  @OneToMany(() => Files, (file) => file.folder)
  files: Files[];
  
 @ManyToOne(() => Folder, folder => folder.children, { nullable: true, 
    onDelete: 'CASCADE',
 })
  parent: Folder;

  @OneToMany(() => Folder, folder => folder.parent,{
    cascade: true,
  })
  children: Folder[];

  @CreateDateColumn()
  createdAt: Date;
}