import { Module } from '@nestjs/common';
import { FilesService } from './files.service';
import { FilesController } from './files.controller';
import { Files } from './entities/files.entity';
import { Folder } from './entities/path.entity';
import { TypeOrmModule } from '@nestjs/typeorm';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [TypeOrmModule.forFeature([Files, Folder]),
      JwtModule.register({ 
            secret: process.env.JWT_SECRET || 'secret', 
          //  signOptions: { expiresIn: '24h' }
          }),
        ],
  controllers: [FilesController],
  providers: [FilesService],
})
export class FilesModule {}
