import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  OneToMany,
  ManyToOne,
} from 'typeorm';
import { Equipament } from 'src/visoflex360/equipaments/entities/equipament.entity';
import { User } from 'src/shared/users/entities/user.entity';

@Entity()
export class Group {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'varchar', nullable: false })
  group_name: string;

  @ManyToOne(() => User, (user) => user.group, {
    eager: true,
    onDelete: 'CASCADE',
  })
  user: User;

  @OneToMany(() => Equipament, (equipament) => equipament.group)
  equipament: Equipament[];
}
