import { Module } from '@nestjs/common';
import { GroupService } from './group.service';
import { GroupController } from './group.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Group } from './entities/group.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [ TypeOrmModule.forFeature([Group]),
  JwtModule.register({ 
        secret: process.env.JWT_SECRET || 'secret', 
      })
  ],
  controllers: [GroupController],
  providers: [GroupService],
})
export class GroupModule {}
