import { IndustrialFan } from './entities/industrial_fan.entity';
import { Inject, Injectable } from '@nestjs/common';
import { CreateIndustrialFanDto } from './dto/create-industrial_fan.dto';
import { UpdateIndustrialFanDto } from './dto/update-industrial_fan.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Schedules } from 'src/visoflex360/equipaments/entities/schedules.entity';

@Injectable()
export class IndustrialFansService {
  constructor(
    @InjectRepository(IndustrialFan)
    private industrialFanRepository: Repository<IndustrialFan>,

    @InjectRepository(Schedules)
    private schedulesRepository: Repository<Schedules>,
  ) {}

  async create(createIndustrialFanDto: CreateIndustrialFanDto) {
    const fan = this.industrialFanRepository.create(createIndustrialFanDto);
    const fanCreated = await this.industrialFanRepository.save(fan);
    const schedule = await this.schedulesRepository.save(
      this.schedulesRepository.create({
        industrial_fan: fan
      }),
    );

  return fan;
  }
}
