import { IsNotEmpty, IsString } from "class-validator";
import { Category } from "src/shared/category/entities/category.entity";

export class CreateModelDto {
    @IsNotEmpty({message: "O nome do modelo é obrigatório"})
    @IsString({message: "O nome do modelo deve conter apenas texto"})
    model_name: string;

    @IsNotEmpty({message: "O modelo deve estar associado a um tipo de equipamento"})
    category: Category;
}
