import { Module } from '@nestjs/common';
import { ModelsService } from './models.service';
import { ModelsController } from './models.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Model } from './entities/model.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [TypeOrmModule.forFeature([Model, User]),
  JwtModule.register({ 
        secret: process.env.JWT_SECRET || 'secret', 
      //  signOptions: { expiresIn: '24h' }
      })],
  controllers: [ModelsController],
  providers: [ModelsService],
})
export class ModelsModule {}
