import { Inject, Injectable, NotFoundException } from '@nestjs/common';
import { CreateModelDto } from './dto/create-model.dto';
import { UpdateModelDto } from './dto/update-model.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Model } from './entities/model.entity';
import { Repository } from 'typeorm';

@Injectable()
export class ModelsService {
  constructor(
    @InjectRepository(Model)
    private modelRepository: Repository<Model>,
  ) {}
  
  async create(createModelDto: CreateModelDto) {
    let model = await this.modelRepository.findOne({
      where: {
        model_name: createModelDto.model_name
      }
    })
    if(!model) {
      const model = this.modelRepository.create(createModelDto)
      return this.modelRepository.save(model);
    }
    return "Esse modelo já existe";
  }

  findAll() {
    return this.modelRepository.find();
  }

  findOne(id: number) {
    return this.modelRepository.findOneBy({id});
  }

  async update(id: number, updateModelDto: UpdateModelDto) {
    const model = await this.modelRepository.findOneBy({id})
    if(!model){
      throw new NotFoundException("Modelo não encontrado");
    }
    this.modelRepository.merge(model, updateModelDto);
    return this.modelRepository.save(model);
  }

  async remove(id: number) {
    const model = await this.modelRepository.findOneBy({id});
    if (!model) {
      throw new Error("Modelo não encontrado");
    }
    return this.modelRepository.remove(model);
  }
}
