import { User } from 'src/shared/users/entities/user.entity';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';
import { Comentario } from './comentario.entity';
import { PostInteration } from './postInteration.entity';

@Entity('post')
export class Post {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  titulo: String;

  @Column()
  subtitulo: String;

  @Column()
  corpo: String;

  @Column()
  data: Date;

  @Column()
  views: number;

  @Column()
  like: number;

  @Column()
  deslike: number;

  @Column({ nullable: true })
  url: string;

  @Column()
  categoria: string;

  @Column()
  tipo: string;

  @ManyToOne(() => User, (user) => user.posts, { onDelete: 'CASCADE' })
  user: User;

  @OneToMany(() => Comentario, (comentario) => comentario.post)
  comentario: Comentario[];

  @OneToMany(() => PostInteration, (postInteration) => postInteration.post)
  postInteration: PostInteration[];
}
