import { Post } from './post.entity';
import { User } from 'src/shared/users/entities/user.entity';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';

@Entity('postinteration')
export class PostInteration {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  viewPost: boolean;

  @Column()
  likePost: boolean;

  @Column()
  deslikePost: boolean;

  @ManyToOne(() => User, (user) => user.postInteration, { onDelete: 'CASCADE' })
  user: User;

  @ManyToOne(() => Post, (post) => post.postInteration, { onDelete: 'CASCADE' })
  post: Post;
}
