import { Module } from '@nestjs/common';
import { PostService } from './post.service';
import { PostController } from './post.controller';
import { JwtModule } from '@nestjs/jwt';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Post } from './entities/post.entity';
import { Comentario } from './entities/comentario.entity';
import { PostInteration } from './entities/postInteration.entity';
import { CourseModule } from 'src/ecommerce/courses/courses.module';
import { AgendaModule } from '../agenda/agenda.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Post, Comentario, PostInteration]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret',
    }),
    CourseModule,
    AgendaModule,
  ],
  controllers: [PostController],
  providers: [PostService],
})
export class PostModule {}
