import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from "typeorm";
import { SubscriptionPlanUser } from "./subscription_plan_user.entity";

@Entity()
export class SubscriptionPlan {
    @PrimaryGeneratedColumn()
    id: number;
    
    @Column()
    nome: string;
    
    @Column()
    price: number;
    
    @Column()
    duration: number;
    
    @Column()
    description: string;

    @OneToMany(() => SubscriptionPlanUser, subscriptionPlanUser => subscriptionPlanUser.subscriptionPlan)
    subscriptionPlanUsers: SubscriptionPlanUser[];

}
