import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';
import { SubscriptionPlan } from './subscription_plan.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { StatusPlan } from 'src/shared/enums/enum';

@Entity()
export class SubscriptionPlanUser {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(
    () => SubscriptionPlan,
    (subscriptionPlan) => subscriptionPlan.subscriptionPlanUsers,
    { onDelete: 'CASCADE' },
  )
  subscriptionPlan: SubscriptionPlan;

  @ManyToOne(() => User, (user) => user.subscriptionPlanUsers, {
    onDelete: 'CASCADE',
  })
  user: User;

  @Column()
  start_date: Date;

  @Column()
  end_date: Date;

  @Column({ type: 'enum', enum: StatusPlan })
  status: StatusPlan;
}
