import { User } from "src/shared/users/entities/user.entity";
import { Entity, JoinColumn, ManyToOne, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Watcher {
    @PrimaryGeneratedColumn()
    id: number;

    @ManyToOne(() => User, user => user.owned_watchers, { onDelete: 'CASCADE'})
    @JoinColumn({ name: 'owner_id' }) 
    user_owner: User;

    @ManyToOne(() => User, user => user.watching, { onDelete: 'CASCADE'})
    @JoinColumn({ name: 'watcher_id' })
    user_watcher: User;

}
